<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('complexes', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('package_translations', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('packages')
						->onDelete('set null')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('complexes', function(Blueprint $table) {
			$table->dropForeign('complexes_user_id_foreign');
		});
		Schema::table('package_translations', function(Blueprint $table) {
			$table->dropForeign('package_translations_package_id_foreign');
		});
	}
}