<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRatesTable extends Migration {

	public function up()
	{
		Schema::create('rates', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('rate', array('1', '2', '3', '4', '5'))->index();
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('rateable_id')->unsigned();
			$table->text('notes')->nullable();
			$table->string('rateable_type');
		});
	}

	public function down()
	{
		Schema::drop('rates');
	}
}