<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->string('promo_code');
			$table->integer('total_price');
			$table->integer('shipping');
			$table->tinyInteger('status');
			$table->bigIncrements('address_id');
			$table->boolean('someone_receive');
			$table->string('payment_id');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}