<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServiceOrdersTable extends Migration {

	public function up()
	{
		Schema::create('service_orders', function(Blueprint $table) {
			$table->increments('id');
			$table->text('subject');
			$table->integer('sheets_no');
			$table->string('academic_level', 255);
			$table->string('lnag', 20);
			$table->text('description');
			$table->string('trans_title', 255);
			$table->string('trans_lag', 255);
			$table->integer('trans_sheat_no');
			$table->integer('trans_period');
			$table->double('trans_money');
			$table->integer('user_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('service_orders');
	}
}