<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('service_category_id')->references('id')->on('service_categories')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('attributes', function(Blueprint $table) {
			$table->foreign('attribute_category_id')->references('id')->on('attribute_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_details', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('service_details', function(Blueprint $table) {
			$table->foreign('size_id')->references('id')->on('sizes')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('service_details', function(Blueprint $table) {
			$table->foreign('color_id')->references('id')->on('colors')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('service_details', function(Blueprint $table) {
			$table->foreign('paper_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('service_details', function(Blueprint $table) {
			$table->foreign('binding_id')->references('id')->on('bindings')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('service_details', function(Blueprint $table) {
			$table->foreign('cellophane_id')->references('id')->on('cellophane')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('service_details', function(Blueprint $table) {
			$table->foreign('cover_id')->references('id')->on('covers')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('service_attributes', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('service_attributes', function(Blueprint $table) {
			$table->foreign('attribute_id')->references('id')->on('attributes')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('invoice_details', function(Blueprint $table) {
			$table->foreign('invoice_id')->references('id')->on('invoices')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('invoice_details', function(Blueprint $table) {
			$table->foreign('service_detail_id')->references('id')->on('service_details')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('invoice_id')->references('id')->on('invoices')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_service_category_id_foreign');
		});
		Schema::table('attributes', function(Blueprint $table) {
			$table->dropForeign('attributes_attribute_category_id_foreign');
		});
		Schema::table('service_details', function(Blueprint $table) {
			$table->dropForeign('service_details_service_id_foreign');
		});
		Schema::table('service_details', function(Blueprint $table) {
			$table->dropForeign('service_details_size_id_foreign');
		});
		Schema::table('service_details', function(Blueprint $table) {
			$table->dropForeign('service_details_color_id_foreign');
		});
		Schema::table('service_details', function(Blueprint $table) {
			$table->dropForeign('service_details_paper_id_foreign');
		});
		Schema::table('service_details', function(Blueprint $table) {
			$table->dropForeign('service_details_binding_id_foreign');
		});
		Schema::table('service_details', function(Blueprint $table) {
			$table->dropForeign('service_details_cellophane_id_foreign');
		});
		Schema::table('service_details', function(Blueprint $table) {
			$table->dropForeign('service_details_cover_id_foreign');
		});
		Schema::table('service_attributes', function(Blueprint $table) {
			$table->dropForeign('service_attributes_service_id_foreign');
		});
		Schema::table('service_attributes', function(Blueprint $table) {
			$table->dropForeign('service_attributes_attribute_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_user_id_foreign');
		});
		Schema::table('invoice_details', function(Blueprint $table) {
			$table->dropForeign('invoice_details_invoice_id_foreign');
		});
		Schema::table('invoice_details', function(Blueprint $table) {
			$table->dropForeign('invoice_details_service_detail_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_invoice_id_foreign');
		});
	}
}