<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('customer_profile', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_subcategories', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('product_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->foreign('subcategories_id')->references('id')->on('product_subcategories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('product_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_images', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('review_feedback', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('review_feedback', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_transaction', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('order')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_transaction', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('customer_profile', function(Blueprint $table) {
			$table->dropForeign('customer_profile_customer_id_foreign');
		});
		Schema::table('product_subcategories', function(Blueprint $table) {
			$table->dropForeign('product_subcategories_category_id_foreign');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->dropForeign('product_subcategories_id_foreign');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->dropForeign('product_category_id_foreign');
		});
		Schema::table('product_images', function(Blueprint $table) {
			$table->dropForeign('product_images_product_id_foreign');
		});
		Schema::table('review_feedback', function(Blueprint $table) {
			$table->dropForeign('review_feedback_customer_id_foreign');
		});
		Schema::table('review_feedback', function(Blueprint $table) {
			$table->dropForeign('review_feedback_product_id_foreign');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->dropForeign('order_customer_id_foreign');
		});
		Schema::table('order_transaction', function(Blueprint $table) {
			$table->dropForeign('order_transaction_order_id_foreign');
		});
		Schema::table('order_transaction', function(Blueprint $table) {
			$table->dropForeign('order_transaction_product_id_foreign');
		});
	}
}