<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSendersTable extends Migration {

	public function up()
	{
		Schema::create('senders', function(Blueprint $table) {
			$table->increments('id');
			$table->string('identity_sendgrid', 64);
			$table->string('identity', 64);
			$table->string('name', 100);
			$table->string('email', 64);
			$table->string('replyto', 64);
			$table->string('address', 100);
			$table->string('city', 100);
			$table->string('state', 100);
			$table->string('zip', 50);
			$table->string('country', 100);
			$table->integer('user_id')->unsigned();
			$table->timestamps();
			$table->binary('validado');
		});
	}

	public function down()
	{
		Schema::drop('senders');
	}
}