<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectTable extends Migration {

	public function up()
	{
		Schema::create('project', function(Blueprint $table) {
			$table->increments('id');
			$table->tinyInteger('opd_id')->unsigned()->index()->default('NULL');
			$table->string('name', 255)->unique()->default('NULL');
			$table->datetime('start_date')->index();
			$table->datetime('end_date')->index();
			$table->text('description')->default('NULL');
			$table->integer('staf_id')->unsigned()->index();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('project');
	}
}