<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Package extends Eloquent {

	protected $table = 'packages';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('doctor_id', 'time', 'cost', 'discount');

	public function doctor()
	{
		return $this->belongsTo('App\Models\Doctor');
	}

}