<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Lessons extends Eloquent {

	protected $table = 'lessons';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function difficulty()
	{
		return $this->hasOne('Difficulties', 'difficulty_id');
	}

	public function templates()
	{
		return $this->hasMany('App\CourseTemplates');
	}

	public function feedbacks()
	{
		return $this->hasOne('App\LessonFeedbacks');
	}

}