<?php

namespace Models;

class Demand extends Eloquent {

	protected $table = 'demand';
	public $timestamps = true;

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function tag()
	{
		return $this->belongsToMany('Tag');
	}

	public function meeting()
	{
		return $this->hasOne('Meeting');
	}

	public function low_category()
	{
		return $this->belongsToMany('LawCategory');
	}

	public function draft()
	{
		return $this->hasMany('Draft');
	}

	public function offer()
	{
		return $this->hasMany('LawyerOffer');
	}

	public function contract()
	{
		return $this->hasOne('DemandContract');
	}

}