<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWebinarDetailsTable extends Migration {

	public function up()
	{
		Schema::create('webinar_details', function(Blueprint $table) {
			$table->increments('id');
			$table->date('date')->nullable();
			$table->time('time')->nullable();
			$table->string('webinar_title', 50)->nullable();
			$table->string('webinar_description', 50)->nullable();
			$table->string('speaker_list')->nullable();
			$table->string('organization_name', 50)->nullable();
			$table->string('partner_list', 50)->nullable();
			$table->string('section_link', 50)->nullable();
			$table->bigInteger('speakers_id')->unsigned();
			$table->bigInteger('partner_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('webinar_details');
	}
}