<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user_profile', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('admin_users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('permissions', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_has_permissions', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_has_permissions', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('webinar_details', function(Blueprint $table) {
			$table->foreign('speakers_id')->references('id')->on('speakers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('webinar_details', function(Blueprint $table) {
			$table->foreign('partner_id')->references('id')->on('partners')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('partner_id')->references('id')->on('partners')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('highlights', function(Blueprint $table) {
			$table->foreign('speaker_id')->references('id')->on('speakers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('user_profile', function(Blueprint $table) {
			$table->dropForeign('user_profile_user_id_foreign');
		});
		Schema::table('admin_users', function(Blueprint $table) {
			$table->dropForeign('admin_users_role_id_foreign');
		});
		Schema::table('permissions', function(Blueprint $table) {
			$table->dropForeign('permissions_role_id_foreign');
		});
		Schema::table('role_has_permissions', function(Blueprint $table) {
			$table->dropForeign('role_has_permissions_role_id_foreign');
		});
		Schema::table('role_has_permissions', function(Blueprint $table) {
			$table->dropForeign('role_has_permissions_permission_id_foreign');
		});
		Schema::table('webinar_details', function(Blueprint $table) {
			$table->dropForeign('webinar_details_speakers_id_foreign');
		});
		Schema::table('webinar_details', function(Blueprint $table) {
			$table->dropForeign('webinar_details_partner_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_partner_id_foreign');
		});
		Schema::table('highlights', function(Blueprint $table) {
			$table->dropForeign('highlights_speaker_id_foreign');
		});
	}
}