<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->string('email', 30)->nullable();
			$table->integer('phone')->nullable();
			$table->text('description')->nullable();
			$table->string('video_link', 50)->nullable();
			$table->string('web_link', 50)->nullable();
			$table->string('socialmedia_link', 50)->nullable();
			$table->string('company_overview', 50)->nullable();
			$table->string('service_name', 50)->nullable();
			$table->text('service_description')->nullable();
			$table->text('company_overview_description')->nullable();
			$table->string('company_overview_count1', 50)->nullable();
			$table->string('company_overview_count2', 50)->nullable();
			$table->string('offer_name', 50)->nullable();
			$table->string('benefit_name', 50)->nullable();
			$table->text('benefit_description')->nullable();
			$table->string('brochure_link', 50)->nullable();
			$table->string('subservice_image', 50)->nullable();
			$table->string('subservice_description', 50)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}