<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('username', 70);
			$table->string('password', 70);
			$table->json('agent')->nullable();
			$table->string('email', 100)->nullable();
			$table->string('phone', 12)->nullable();
			$table->tinyInteger('percent_profit')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}