<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOperationRecordsTable extends Migration {

	public function up()
	{
		Schema::create('operation_records', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('actionable_type', 150)->nullable();
			$table->integer('actionable_id')->nullable();
			$table->json('response')->nullable();
			$table->integer('webservice_id')->unsigned()->nullable();
			$table->string('uuid', 70)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('operation_records');
	}
}