<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('months', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('exspenses', function(Blueprint $table) {
			$table->foreign('month_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('shops', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('lists', function(Blueprint $table) {
			$table->foreign('shop_id')->references('id')->on('shops')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->foreign('list_id')->references('id')->on('lists')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('income', function(Blueprint $table) {
			$table->foreign('month_id')->references('id')->on('months')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('months', function(Blueprint $table) {
			$table->dropForeign('months_user_id_foreign');
		});
		Schema::table('exspenses', function(Blueprint $table) {
			$table->dropForeign('exspenses_month_id_foreign');
		});
		Schema::table('shops', function(Blueprint $table) {
			$table->dropForeign('shops_user_id_foreign');
		});
		Schema::table('lists', function(Blueprint $table) {
			$table->dropForeign('lists_shop_id_foreign');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->dropForeign('items_list_id_foreign');
		});
		Schema::table('income', function(Blueprint $table) {
			$table->dropForeign('income_month_id_foreign');
		});
	}
}