<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemsTable extends Migration {

	public function up()
	{
		Schema::create('items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title');
			$table->bigInteger('price');
			$table->integer('quantity');
			$table->integer('list_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('items');
	}
}