<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Month extends Eloquent {

	protected $table = 'months';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function exspenses()
	{
		return $this->hasMany('Exspense');
	}

	public function income()
	{
		return $this->hasMany('Income');
	}

}