<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Shop extends Eloquent {

	protected $table = 'shops';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'location', 'user_id');

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function lists()
	{
		return $this->hasMany('List');
	}

}