<?php

class Category extends Eloquent {

	protected $table = 'categories';
	public $timestamps = true;

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function sales()
	{
		return $this->morphMany('Sale', 'saleable')->whereActive(true);
	}

	public function children()
	{
		return $this->hasMany('Category', 'parent_id', 'id');
	}

}