<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductVariationsTable extends Migration {

	public function up()
	{
		Schema::create('product_variations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('product_id')->unsigned()->index();
			$table->text('details');
			$table->integer('order')->nullable();
			$table->integer('product_variation_type_id')->unsigned()->index();
		});
	}

	public function down()
	{
		Schema::drop('product_variations');
	}
}