<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned();
			$table->string('photo')->nullable();
			$table->string('name')->unique();
			$table->text('description');
			$table->boolean('reviewed')->default(0);
			$table->date('reviewed_at')->nullable();
			$table->integer('price');
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}