<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBlogPostsTable extends Migration {

	public function up()
	{
		Schema::create('blog_posts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->timestamp('released_at');
			$table->string('sub_title')->nullable();
			$table->string('content');
			$table->integer('reject_id')->unsigned()->nullable();
			$table->boolean('visible');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('blog_posts');
	}
}