<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlayersTable extends Migration {

	public function up()
	{
		Schema::create('players', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->integer('race_id')->unsigned();
			$table->integer('player_type_id')->unsigned();
			$table->integer('cost');
			$table->integer('max_in_team')->default('1');
			$table->integer('movement');
			$table->integer('strength');
			$table->integer('agility');
			$table->integer('armor_value');
		});
	}

	public function down()
	{
		Schema::drop('players');
	}
}