<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMatchesTable extends Migration {

	public function up()
	{
		Schema::create('matches', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('team1_id');
			$table->integer('team2_id');
			$table->integer('score_club1');
			$table->integer('score_club2')->default('0');
			$table->datetime('start_time')->nullable();
			$table->string('place');
			$table->datetime('end_time')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('matches');
	}
}