<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('credentials', function(Blueprint $table) {
			$table->foreign('website_id')->references('id')->on('websites')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('credentialtypes', function(Blueprint $table) {
			$table->foreign('credential_id')->references('id')->on('credentials')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('credentialfields', function(Blueprint $table) {
			$table->foreign('credentialtype_id')->references('id')->on('credentialtypes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('credentialfieldentries', function(Blueprint $table) {
			$table->foreign('credentialfield_id')->references('id')->on('credentialfields')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('credentialfieldentries', function(Blueprint $table) {
			$table->foreign('credential_id')->references('id')->on('credentials')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('websites', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('credentials', function(Blueprint $table) {
			$table->dropForeign('credentials_website_id_foreign');
		});
		Schema::table('credentialtypes', function(Blueprint $table) {
			$table->dropForeign('credentialtypes_credential_id_foreign');
		});
		Schema::table('credentialfields', function(Blueprint $table) {
			$table->dropForeign('credentialfields_credentialtype_id_foreign');
		});
		Schema::table('credentialfieldentries', function(Blueprint $table) {
			$table->dropForeign('credentialfieldentries_credentialfield_id_foreign');
		});
		Schema::table('credentialfieldentries', function(Blueprint $table) {
			$table->dropForeign('credentialfieldentries_credential_id_foreign');
		});
		Schema::table('websites', function(Blueprint $table) {
			$table->dropForeign('websites_company_id_foreign');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->dropForeign('contacts_company_id_foreign');
		});
	}
}