<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OfferGetproduct extends Model 
{

    protected $table = 'offer_getproduct';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('product_id', 'offer_id');
    protected $visible = array('product_id');

    public function product()
    {
        return $this->belongsTo('Product', 'product_id');
    }

    public function offer()
    {
        return $this->belongsTo('Offer', 'offer_id');
    }

}