<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Schedule extends Model 
{

    protected $table = 'schedule';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('days', 'from_hour', 'to_hour', 'is_day_off', 'branch_id');

    public function branch()
    {
        return $this->belongsTo('Branch', 'branch_id');
    }

}