<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientTable extends Migration {

	public function up()
	{
		Schema::create('client', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->nullable();
			$table->string('last_name')->nullable();
			$table->string('phone')->nullable();
			$table->string('email')->nullable();
			$table->datetime('birth_date')->nullable();
			$table->integer('work_field')->nullable();
			$table->string('work_name')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('client');
	}
}