<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateScheduleTable extends Migration {

	public function up()
	{
		Schema::create('schedule', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('days')->nullable();
			$table->string('from_hour')->nullable();
			$table->string('to_hour')->nullable();
			$table->boolean('is_day_off')->default(0);
			$table->integer('branch_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('schedule');
	}
}