<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('professional_project', function(Blueprint $table) {
			$table->foreign('project_id')->references('project_id')->on('professional_project')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('professional_project', function(Blueprint $table) {
			$table->foreign('professional_id')->references('professional_id')->on('professional_project')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('professionals_id')->references('id')->on('professionals')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_user_id_foreign');
		});
		Schema::table('professional_project', function(Blueprint $table) {
			$table->dropForeign('professional_project_project_id_foreign');
		});
		Schema::table('professional_project', function(Blueprint $table) {
			$table->dropForeign('professional_project_professional_id_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_project_id_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_user_id_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_professionals_id_foreign');
		});
	}
}