<?php

namespace Freelance;

use Illuminate\Database\Eloquent\Model;

class Project extends Model 
{

    protected $table = 'projects';
    public $timestamps = true;

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function candidates()
    {
        return $this->belongsToMany('Project');
    }

    public function executer()
    {
        return $this->hasOne('Professional');
    }

}