<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('projects', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned()->nullable();
			$table->text('code')->nullable();
			$table->integer('duration')->nullable();
			$table->integer('value')->nullable();
			$table->string('file')->nullable();
			$table->string('title', 255);
		});
	}

	public function down()
	{
		Schema::drop('projects');
	}
}