<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Pegawai extends Model 
{

    protected $table = 'pegawai';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'nip', 'username', 'personnel_area', 'personnel_subarea', 'personnel_area_name', 'personnel_subarea_name', 'position');

    public function mapping()
    {
        return $this->hasMany('App\Mapping', 'personnnel_subarea_name', 'unit');
    }

}