<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('tenant_id')->unsigned()->index();
			$table->string('name')->index();
			$table->string('email');
			$table->string('phone');
			$table->tinyInteger('type')->index();
			$table->string('password');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}