<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('tenant_id')->references('id')->on('tenants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tenants', function(Blueprint $table) {
			$table->foreign('owner_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tenants', function(Blueprint $table) {
			$table->foreign('tanent_type_id')->references('id')->on('tenant_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('areas', function(Blueprint $table) {
			$table->foreign('governorate_id')->references('id')->on('governorates')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->foreign('tenant_id')->references('id')->on('tenants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('area_tenant', function(Blueprint $table) {
			$table->foreign('area_id')->references('id')->on('areas')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('area_tenant', function(Blueprint $table) {
			$table->foreign('tenant_id')->references('id')->on('tenants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_status_logs', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_notes', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_notes', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_tenant_id_foreign');
		});
		Schema::table('tenants', function(Blueprint $table) {
			$table->dropForeign('tenants_owner_id_foreign');
		});
		Schema::table('tenants', function(Blueprint $table) {
			$table->dropForeign('tenants_tanent_type_id_foreign');
		});
		Schema::table('areas', function(Blueprint $table) {
			$table->dropForeign('areas_governorate_id_foreign');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->dropForeign('items_tenant_id_foreign');
		});
		Schema::table('area_tenant', function(Blueprint $table) {
			$table->dropForeign('area_tenant_area_id_foreign');
		});
		Schema::table('area_tenant', function(Blueprint $table) {
			$table->dropForeign('area_tenant_tenant_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_store_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_customer_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_customer_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_order_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_item_id_foreign');
		});
		Schema::table('order_status_logs', function(Blueprint $table) {
			$table->dropForeign('order_status_logs_user_id_foreign');
		});
		Schema::table('order_notes', function(Blueprint $table) {
			$table->dropForeign('order_notes_user_id_foreign');
		});
		Schema::table('order_notes', function(Blueprint $table) {
			$table->dropForeign('order_notes_order_id_foreign');
		});
	}
}