<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAboutCmsTable extends Migration {

	public function up()
	{
		Schema::create('about_cms', function(Blueprint $table) {
			$table->increments('id');
			$table->string('banner_title');
			$table->text('banner_logo');
			$table->text('banner_logo_alt');
			$table->text('about_description');
			$table->enum('about_media_type', array('video', 'image'));
			$table->text('about_media_desktop_path');
			$table->text('about_media_mobile_path');
			$table->text('about_media_alt');
			$table->string('learn_more_title');
			$table->text('learn_more_description');
			$table->text('learn_more_media_path');
			$table->text('learn_more_media_alt');
			$table->string('our_mission_title');
			$table->text('our_mission_description');
			$table->string('our_vision_title');
			$table->text('our_vision_description');
			$table->string('leading_game_title');
			$table->integer('charging_station_count');
			$table->string('charging_station_subtitle');
			$table->string('our_values_title');
			$table->text('our_values_description');
			$table->string('our_journey_title');
			$table->text('our_journey_description');
			$table->string('meet_team_title');
			$table->text('meet_team_description');
			$table->text('meet_team_media_path');
			$table->text('meet_team_media_alt');
			$table->string('our_associate_title');
			$table->text('our_associate_description');
			$table->string('media_title');
			$table->text('media_description');
			$table->string('contact_us_super_title');
			$table->string('contact_us_title');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('about_cms');
	}
}