<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCeirDetailTable extends Migration {

	public function up()
	{
		Schema::create('ceir_detail', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('priority_group', array('A1', 'A2', 'A3'));
			$table->string('sub_priority_group');
			$table->string('firstname', 100);
			$table->string('lastname', 100);
			$table->string('middlename', 100);
			$table->string('suffix', 100);
			$table->string('contact_no', 50);
			$table->string('email', 100);
			$table->string('region', 100);
			$table->string('province', 100);
			$table->string('city', 100);
			$table->string('barangay', 100);
			$table->string('gender', 100);
			$table->date('date_of_birth');
			$table->string('occupation', 100);
			$table->boolean('has_allergy');
			$table->boolean('has_commorbidity');
			$table->bigInteger('patient_id')->unsigned();
			$table->bigInteger('verified_by');
			$table->boolean('is_verified')->default(True);
			$table->string('upload_by', 50)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('ceir_detail');
	}
}