<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePatientVaccinationDetailTable extends Migration {

	public function up()
	{
		Schema::create('patient_vaccination_detail', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('patient_id')->unsigned();
			$table->enum('injected_arm', array('L-ARM', 'R-ARM'));
			$table->longText('vaccinator_signature_link');
			$table->longText('patient_signature_link');
			$table->bigInteger('vaccination_time_slot')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('patient_vaccination_detail');
	}
}