<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRealEstateDetailsTable extends Migration {

	public function up()
	{
		Schema::create('real_estate_details', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->string('label', 255);
			$table->tinyInteger('property_type')->unsigned();
			$table->tinyInteger('room_count')->unsigned();
			$table->smallInteger('area')->unsigned();
			$table->mediumInteger('budget')->unsigned();
			$table->tinyInteger('works_type')->index();
			$table->tinyInteger('ground_area_type')->unsigned();
			$table->tinyInteger('parking_type')->unsigned();
			$table->char('dpe_ges_rank')->nullable();
			$table->char('dpe_consumption_rank')->nullable();
			$table->text('details')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('real_estate_details');
	}
}