<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsTable extends Migration {

	public function up()
	{
		Schema::create('settings', function(Blueprint $table) {
			$table->increments('id');
			$table->string('slug', 191)->nullable();
			$table->string('name', 255)->nullable();
			$table->mediumText('value')->nullable();
			$table->smallInteger('type')->nullable();
			$table->string('module', 191)->nullable();
			$table->smallInteger('orderBy')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('settings');
	}
}