<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('projects', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid');
			$table->integer('owner_id')->unsigned();
			$table->string('title');
			$table->text('description')->nullable();
			$table->timestamp('created_at');
			$table->timestamp('updated_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('projects');
	}
}