<?php

namespace App\Models\Assign\Assign;

class Assign extends Eloquent {

	protected $table = 'assigns';
	public $timestamps = false;
	protected $fillable = array('assignable_id', 'assignable_type');

	public function user()
	{
		return $this->belongsTo('User', 'id', 'user_id');
	}

	public function projects()
	{
		return $this->morphedByMany('Project');
	}

	public function tasks()
	{
		return $this->morphedByMany('Task');
	}

}