<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressesTable extends Migration {

	public function up()
	{
		Schema::create('addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->index();
			$table->string('label', 40);
			$table->string('lat');
			$table->string('lng');
			$table->integer('building_num')->nullable();
			$table->integer('floor_num')->nullable();
			$table->integer('apartment_num')->nullable();
			$table->text('address')->nullable();
			$table->tinyInteger('is_primary')->default('0');
			$table->tinyInteger('status')->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('addresses');
	}
}