<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('address_id')->unsigned();
			$table->integer('client_id')->unsigned()->index();
			$table->string('client_name')->nullable();
			$table->string('client_mobile')->nullable();
			$table->integer('provider_id')->unsigned()->index();
			$table->string('provider_name')->nullable();
			$table->string('provider_mobile')->nullable();
			$table->integer('service_id')->unsigned()->index();
			$table->string('service_name');
			$table->string('parent_service_id');
			$table->string('parent_service_name');
			$table->datetime('date');
			$table->tinyInteger('status');
			$table->integer('service_cost')->nullable();
			$table->integer('provider_commission');
			$table->integer('net_profit');
			$table->integer('rate')->nullable();
			$table->text('rate_note');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}