<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProviderTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('provider_transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('provider_id')->unsigned()->index();
			$table->string('provider_name');
			$table->string('provider_mobile');
			$table->integer('cost');
			$table->integer('bank_id')->unsigned();
			$table->string('bank_name')->index();
			$table->tinyInteger('status');
			$table->string('acc_num');
			$table->string('iban');
			$table->string('acc_name');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('provider_transactions');
	}
}