<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'blood_type_id', 'date_of_birth', 'last_donation_date', 'phone', 'password', 'city_id', 'pin_code');

    public function blood-_type()
    {
        return $this->hasOne('BT', 'blood_type_id');
    }

    public function city()
    {
        return $this->belongsTo('City', 'city_id');
    }

}