<?php

namespace App\Models;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	public function options()
	{
		return $this->hasMany('App\Models\ProductOption');
	}

	public function images()
	{
		return $this->hasMany('App\Models\ProductsImage');
	}

	public function pricing()
	{
		return $this->hasOne('App\Models\ProductsPrice');
	}

	public function priceTiers()
	{
		return $this->hasOne('App\Models\ProductsPriceTier');
	}

	public function categories()
	{
		return $this->belongsToMany('App\Models\Category');
	}

}