<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Project extends Model 
{

    protected $table = 'proj_projects';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function tasks()
    {
        return $this->hasMany('App\Task');
    }

    public function category()
    {
        return $this->belongsTo('App\ProjCategory');
    }

    public function status()
    {
        return $this->belongsTo('App\ProjStatus');
    }

    public function user()
    {
        return $this->belongsTo('App\User');
    }

    public function contact()
    {
        return $this->belongsTo('App\Contact');
    }

    public function bills()
    {
        return $this->hasMany('App\Bill');
    }

}